/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.va.med.term.mvx.propertyTypes;

import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.BPT_Descriptions;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.Property;

/**
 * 
 * {@link PT_Descriptions}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class PT_Descriptions extends BPT_Descriptions {
	public enum Descriptions {
		ManufacturerName("Manufacturer Name", FSN);
		
		private final int descriptionType_;
		private final String niceName_;
		private Property property_;
		
		private Descriptions(String niceName, int descriptionType) {
			descriptionType_= descriptionType;
			niceName_ = niceName;
		}
		public int getDescriptionType() { return descriptionType_; }
		
		public Property getProperty()
		{
			return property_;
		}
	}

	public PT_Descriptions()
	{
		super("MVX");

		for (Descriptions description : Descriptions.values()) {
			description.property_ = addProperty(description.niceName_, description.getDescriptionType());
		}
	}
}
